//
//  FSFileInfoCell.m
//  PDFReader
//
//  Created by Dong Li on 12-4-25.
//  Copyright (c) 2013年 ITX. All rights reserved.
//

#import "FSFileInfoCell.h"
#import "FSFileItem.h"

@implementation FSFileInfoCell

@synthesize fileItem = _fileItem;

static BOOL _initialized = NO;
static UIImage *_selectedIcon = nil;
static UIImage *_deselectedIcon = nil;

+ (void)initialize {
    if (!_initialized) {
        _selectedIcon = [UIImage imageNamed:@"fi/selected.png"];
        _deselectedIcon = [UIImage imageNamed:@"fi/deselected.png"];
        _initialized = YES;
    }
}

- (id)initWithReuseIdentifier:(NSString *)reuseIdentifier {
    if (self = [super initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:reuseIdentifier]) {
        UIView *backgroundView = [[UIView alloc] initWithFrame:CGRectZero];
        
        [backgroundView setBackgroundColor:UIColorWhite];
        [self setBackgroundView:backgroundView];
        
        UIView *contentVeiw = [self contentView];
        UILabel *textLabel = [self textLabel];
        UILabel *detailLabel = [self detailTextLabel];
        
        
        [contentVeiw setClipsToBounds:NO];
        [contentVeiw setBackgroundColor:UIColorClear];
        [textLabel setBackgroundColor:UIColorClear];
        [textLabel setFont:UIFontBold16];
        [textLabel setAdjustsFontSizeToFitWidth:YES];
        [textLabel setMinimumScaleFactor:0.5];
        [textLabel setNumberOfLines:2];
        [detailLabel setBackgroundColor:UIColorClear];
        [detailLabel setFont:UIFontNormal12];
        
        _editingIconView = [[UIImageView alloc] initWithImage:_deselectedIcon];
        [_editingIconView setCenter:CGPointMake(-12, 27)];
        [contentVeiw addSubview:_editingIconView];
        
        _statisticLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        [_statisticLabel setBackgroundColor:UIColorClear];
        [_statisticLabel setTextColor:UIColorGray];
        [_statisticLabel setHighlightedTextColor:UIColorWhite];
        [_statisticLabel setFont:UIFontNormal12];
        [_statisticLabel setTextAlignment:NSTextAlignmentRight];
        [contentVeiw addSubview:_statisticLabel];
        
        [self setSelectionStyle:UITableViewCellSelectionStyleGray];
        [self setAccessoryType:UITableViewCellAccessoryDisclosureIndicator];
    }
    return self;
}

- (void)dealloc {
}

- (void)updateSelectionState {
    BOOL isSelected = [_fileItem isSelected];
    
    [[self contentView] setAlpha:([_fileItem isCut] ? 0.5f : 1.f)];
    [[self backgroundView] setBackgroundColor:(isSelected ? UIColorSelectedBackground : UIColorWhite)];
    [_editingIconView setImage:(isSelected ? _selectedIcon : _deselectedIcon)];
}

- (void)willTransitionToState:(UITableViewCellStateMask)state {
    if (UITableViewCellStateEditingMask & state) {
        [self updateSelectionState];
    }
}

- (void)didTransitionToState:(UITableViewCellStateMask)state {
    if (0 == (UITableViewCellStateEditingMask & state)) {
        [self updateSelectionState];
    }
}

- (void)layoutSubviews {
    [super layoutSubviews];
    
    UILabel *detailTextLabel = [self detailTextLabel];
    CGRect detailFrame = [detailTextLabel frame];
    const CGFloat contentWidth = self.contentView.bounds.size.width;
    const CGFloat restCap = contentWidth - detailFrame.origin.x - 10;
    
    detailFrame.size.width = restCap * 2.f / 3.f;
    [detailTextLabel setFrame:detailFrame];
    
    const CGFloat statisticWidth = restCap / 3.f;
    CGRect statisticFrame = { contentWidth - statisticWidth - 10.f, detailFrame.origin.y, statisticWidth, detailFrame.size.height };
    
    [_statisticLabel setFrame:statisticFrame];
}

- (void)setFileItem:(FSFileItem *)newFileItem {
    _fileItem = newFileItem;
    [_fileItem loadAttributesIfNeeded];
    
    [self updateSelectionState];
    [[self imageView] setImage:[UIImage imageNamed:[_fileItem iconName]]];
    [[self textLabel] setText:[_fileItem displayName]];
    [[self detailTextLabel] setText:[_fileItem creationTime]];
    [_statisticLabel setText:[_fileItem statistic]];
}

@end
